#
#!/usr/bin/perl
#use Win32::OLE;
use Win32::OLE::Variant;
use strict;
use POSIX qw(strftime);

# ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ********************************************************************************

# ********************** LICENSE STRINGS ***********************
# *     To unlock the full functionality of Address Object,    *
# * please call a sales representative at 1-800-MELISSA ext. 3 * 
# *         (1-800-635-4772 x3) for a license string.          *
# *      Without a valid license string, AddressCheck will     *
# *                only verify Nevada addresses.               *
# **************************************************************
my $dLICENSE = "DEMO";

# ********************** DATA FILE PATH  ***********************
# File location path is set to the default Data File location. *
# Change this value if you installed the data files to a       *
# different folder.                                            *
# The Data Files Directory must contain the following files:   *
# mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
# **************************************************************
my $dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";

my $addrObj = Win32::OLE->new('AddressObject.AddressCheck') or die "No Address Check Found\n";
my $parseObj = Win32::OLE->new('AddressObject.Parse') or die "No Address Check Found\n";
my $streetObj = Win32::OLE->new('AddressObject.StreetData') or die "No Address Check Found\n";
my $zipObj = Win32::OLE->new('AddressObject.ZipCodeData') or die "No Address Check Found\n";

#Loading Default Test Data
my $company = "ABC Company";
my $address = "201 10th St.";
my $address2;
my $city = "Las Vegas";
my $state = "NV";
my $zip = "89101";
my $plus4;
my $lastline = "Las Vegas, NV 89101-5519";
my $city2 = "L*";
my $lastname = "Enter Last Name Here";
my $Results;


sub init_addrObj{
	#set License
	$addrObj->SetLicenseString($dLICENSE);
	$addrObj->{PathToUSFiles} = $dFILELOC;
	#$addrObj->{PathToCanadaFiles} = $dFILELOC;		#Canadian Addon
	#$addrObj->{PathToDPVDataFiles} = $dFILELOC;		#DPV Addon
	#$addrObj->{PathToLACSLinkDataFiles} = $dFILELOC;	#LACS Link Addon
	#$addrObj->{PathToRBDIFiles} = $dFILELOC;		#RBDI Addon
	#$addrObj->{PathToSuiteLinkDataFiles} = $dFILELOC;	#Suite Link Addon
	#$addrObj->{PathToSuiteFinderDataFiles} = $dFILELOC;	#Suite Finder Addon

	# Initialize
	my $InitResult = $addrObj->InitializeDataFiles();
	if ($InitResult != 0)  # Initialization failed
	{
		printf $addrObj->GetInitializeErrorString(), "\n";
		die "Cannot Initialize Address Object";	
	}
}

sub verify_address{
	#clear any remaining properties from previous calls
  $addrObj->ClearProperties();

	#load properties first
	$addrObj->{Company} = $company;
	$addrObj->{Address} = $address;
	$addrObj->{Address2} = $address2;
	$addrObj->{City} = $city;
	$addrObj->{State} = $state;
	$addrObj->{Zip} = $zip;
	$addrObj->{Plus4}=$plus4; 
	$addrObj->{LastName}="Enter Last Name Here"; 

	# Verify the Address
	$addrObj->VerifyAddress();
}
sub print_addrObj{
# Print Results

print "========================================================================\n";
print "          Build Number: ", $addrObj->GetBuildNumber(), "\n";
print "     Initialize Status: ", $addrObj->GetInitializeErrorString(), "\n";
print "         Database Date: ",$addrObj->GetDatabaseDate() , "\n";
print "       Expiration Date: ", $addrObj->GetUSExpirationDate(), "\n";
print "========================================================================\n";
print "\n";
print "\nOUTPUT ADDRESS...\n";
print " Company:     ", $addrObj->{Company}, "\n";
print " Address:     ", $addrObj->{Address}, "\n";
print " Address2:    ", $addrObj->{Address2}, "\n";
print " Suite:       ", $addrObj->{Suite}, "\n";
print " City:        ", $addrObj->{City}, "\n";
print " State:       ", $addrObj->{State}, "\n";
print " Zip:         ", $addrObj->{Zip}, "\n";
print " Plus4:       ", $addrObj->{Plus4}, "\n";
print "\nRESULTS...\n";

# Results are returned as a delimited string, so we parse the codes...
$Results = $addrObj->{Results};
if (($Results =~ m/AS01/i) || ($Results =~ m/AS02/i) || ($Results =~ m/AS03/i))
# the address has been verified
{
   if ($Results =~ m/AS01/i)
   {
        print " AS01: Full Address Matched to Postal Database and is deliverable\n";
   }
   if ($Results =~ m/AS02/i)
   {
        print " AS02: Address matched to USPS database but a suite was missing or invalid\n";
   }
   if ($Results =~ m/AS03/i)
	{
		print " AS03: Valid Physical Address, not Serviced by the USPS \n";
	}
}

# Display additional level of verification/comments

if ($Results =~ m/AS09/i)
{
     print " AS09: Foreign Postal Code Detected \n";
}
if ($Results =~ m/AS10/i)
{
     print " AS10: Address Matched to CMRA\n";
}
if ($Results =~ m/AS13/i)
{
     print " AS13: Address has been Updated by LACSLink \n";
}
if ($Results =~ m/AS14/i)
{
     print " AS14: Suite Appended by SuiteLink \n";
}
if ($Results =~ m/AS15/i)
{
     print " AS15: Suite Appended by SuiteFinder \n";
}
if ($Results =~ m/AS16/i)
{
     print " AS16: Address is vacant.\n";
}
if ($Results =~ m/AS17/i)
{
     print " AS17: Alternate delivery.\n";
}
if ($Results =~ m/AS18/i)
{
     print " AS18: DPV processing was terminated artificially created adresses detected.\n";
}
if ($Results =~ m/AS20/i)
{
     print " AS20: Address Deliverable by USPS only \n";
}
if ($Results =~ m/AS21/i)
{
     print " AS21: Alternate Address Suggestion Found\n";
}
if ($Results =~ m/AS22/i)
{
     print " AS22: No Alternate Address Suggestion Found\n";
}
if ($Results =~ m/AS23/i)
{
     print " AS23: Extraneous information found \n";
}	

# there was an error in verifying the address...
if ($Results =~ m/AE/i)
{
	 print " Address could not be verified... \n";
   if ($Results =~ m/AE01/i)
   {
       print " AE01: Zip Code Error \n";
   }
   if ($Results =~ m/AE02/i)
   {
       print " AE02: Unknown Street Error \n";
   }   
   if ($Results =~ m/AE03/i)
   {
      print " AE03: Component Mismatch Error \n";
   }   
   if ($Results =~ m/AE04/i)
   {
      print " AE04: Non-Deliverable Address Error \n";
   }   
   if ($Results =~ m/AE05/i)
   {
      print " AE05: Multiple Match Error \n";
   }   
   if ($Results =~ m/AE06/i)
   {
      print " AE06: Early Warning System Error \n";
   }   
   if ($Results =~ m/AE07/i)
   {
      print " AE07: Missing Minimum Address Input \n";
   }   
   if ($Results =~ m/AE08/i)
   {
      print " AE08: Suite Range Invalid Error\n";
   }   
   if ($Results =~ m/AE09/i)
   {
      print " AE09: Suite Range Missing Error \n";
   }   
   if ($Results =~ m/AE10/i)
   {
      print " AE10: Primary Range Invalid Error \n";
   }   
   if ($Results =~ m/AE11/i)
   {
      print " AE11: Primary Range Missing Error \n";
   }   
   if ($Results =~ m/AE12/i)
   {
      print " AE12: PO, HC, or RR Box Number Invalid \n";
   }   
   if ($Results =~ m/AE13/i)
   {
      print " AE13: PO, HC, or RR Box Number Missing \n";
   }   
   if ($Results =~ m/AE14/i)
   {
      print " AE14: CMRA Secondary Missing Error\n";
   }

# the address could not go through the verifying process
   if ($Results =~ m/AE15/i)
   {
      print " AE15: Demo Mode, valid license required for full processing \n";
   }   
   if ($Results =~ m/AE16/i)
   {
      print " AE16: Expired Database, Please Update\n";
   }
   
   if ($Results =~ m/AE17/i)
   {
      print " AE17: Unnecessary Suite Error \n";
   }   
   if ($Results =~ m/AE19/i)
   {
      print " AE19: Max time for FindSuggestion exceeded \n";
   }   
   if ($Results =~ m/AE20/i)
   {
      print " AE20: FindSuggestion cannot be used\n";
   }
   
} 

# there was a change to the input data
if ($Results =~ m/AC01/i)
{
     print " AC01: ZIP Code Change\n";
}
if ($Results =~ m/AC02/i)
{
     print " AC02: State Change\n";
}
if ($Results =~ m/AC033/i)
{
     print " AC03: City Change \n";
}
if ($Results =~ m/AC04/i)
{
     print " AC04: Base/Alternate Change \n";
}
if ($Results =~ m/AC05/i)
{
     print " AC05: Alias Name Change\n";
}
if ($Results =~ m/AC06/i)
{
     print " AC06: Address1/Address2 Swap\n";
}
if ($Results =~ m/AC07/i)
{
     print " AC07: Address1/Company Swap\n";
}
if ($Results =~ m/AC08/i)
{
     print " AC08: Plus4 Change\n";
}
if ($Results =~ m/AC09/i)
{
     print " AC09: Urbanization Change \n";
}
if ($Results =~ m/AC10/i)
{
     print " AC10: Street Name Change\n";
} 
if ($Results =~ m/AC11/i)
{
     print " AC11: Street Suffix Change\n";
}
if ($Results =~ m/AC12/i)
{
     print " AC12: Street Directional Change \n";
}
if ($Results =~ m/AC13/i)
{
     print " AC13: Suite Name Change\n";
}

print "\n";
print " Carrier Route:            ", $addrObj->{CarrierRoute}, "\n";
print " Delivery Point Code:      ", $addrObj->{DeliveryPointCode}, "\n";
print " DeliveryPointCheckDigit : ", $addrObj->{DeliveryPointCheckDigit}, "\n";
print " DPV Footnotes:            ", $addrObj->{DPVFootnotes}, "\n";
print "\n";
print " Address Type:             ", $addrObj->{AddressTypecode}, "\n";
print " Address Type String:      ", $addrObj->{AddressTypeString}, "\n";
print " City Abbreviation :       ", $addrObj->{CityAbbreviation}, "\n";
print " County:                   ", $addrObj->{CountyName}, "\n";
print " County Fips:              ", $addrObj->{CountyFips}, "\n";
print " Country Code:             ", $addrObj->{CountryCode}, "\n";
print " Congressional District:   ", $addrObj->{CongressionalDistrict}, "\n";
print " Time Zone:                ", $addrObj->{TimeZone}, "\n";
print " Time Zone Code:           ", $addrObj->{TimeZoneCode}, "\n";
print " Urbanization:             ", $addrObj->{Urbanization}, "\n";
print " ZipType:                  ", $addrObj->{ZipType}, "\n\n";
print "\n";
print "== Parsed Input Data ===================================================\n";
print " Suite Name:            ", $addrObj->{ParesdSuiteName}, "\n";
print " Suite Range:           ", $addrObj->{ParsedSuiteRange}, "\n";
print " Address Range:         ", $addrObj->{ParsedAddressRange}, "\n";
print " Address PreDirection:  ", $addrObj->{ParsedPreDirection}, "\n";
print " Street Name:           ", $addrObj->{ParsedStreetName}, "\n";
print " Suffix:                ", $addrObj->{ParsedSuffix}, "\n";
print " Post Direction:        ", $addrObj->{ParsedPostDirection}, "\n";
print " Private MB Name:       ", $addrObj->{ParsedPrivateMailboxName}, "\n";
print " Private MB Number:     ", $addrObj->{ParsedPrivateMailboxNumber}, "\n";
print " Garbage:               ", $addrObj->{ParsedGarbage}, "\n";
print "\n";
print " MSA:                   ", $addrObj->{Msa}, "\n";
print " PMSA:                  ", $addrObj->{Pmsa}, "\n";
print " CMRA:                  ", $addrObj->{CMRA}, "\n";
print " PrivateMailBox:        ", $addrObj->{PrivateMailbox}, "\n";
print "\n";
print " ELot Order:            ", $addrObj->{ELotOrder}, "\n";
print " ELot Number:           ", $addrObj->{ELotNumber}, "\n";
print " LACS:                  ", $addrObj->{LACS}, "\n";
print " LACS Link Indicator:   ", $addrObj->{LACSLinkIndicator}, "\n";
print " LACS Link Return Code: ", $addrObj->{LACSLinkReturnCode}, "\n";
print " Suite Link Return Code ", $addrObj->{SuiteLinkReturnCode}, "\n";
print " EWS Flag:              ", $addrObj->{EWSFlag}, "\n";
print " RBDI:                  ", $addrObj->{RBDI}, "\n";

}



sub print_parse{

# Print Results
	# Print properties
	print " SNm: ", $parseObj->{SuiteName};
	print " SNum: ", $parseObj->{SuiteNumber};
	print " Rng: ", $parseObj->{Range};
	print " PreDir: ", $parseObj->{PreDirection};
	print " PstDir: ", $parseObj->{PostDirection};
	print " StrtNm: ", $parseObj->{StreetName};
	print " Suff: ", $parseObj->{Suffix};
	print " Grbg: ", $parseObj->{Garbage}, "\n";

}
sub print_lastline{
	# Print properties
	print "========================================================================\n";
	print "      Build Number: ", $parseObj->GetBuildNumber(), "\n";
	print "  Parsed Last Line: ",$lastline,"\n";
	print "========================================================================\n";
	print " City:                  ", $parseObj->{City}, "\n";
	print " State:                 ", $parseObj->{State}, "\n";
	print " Zip:                   ", $parseObj->{Zip}, "\n";
	print " Plus4:                 ", $parseObj->{Plus4}, "\n";
}

sub init_streetObj{
	# set License
	$streetObj->SetLicenseString($dLICENSE);

	# Initialize
	# Set path to data files in the call to the Initialize method
	my $InitResult = $streetObj->Initialize($dFILELOC,$dFILELOC,"");

	if ($InitResult != 0)   # Initialize failed
	{
		printf $streetObj->GetInitializeErrorString(), "\n";
		die "Cannot Initialize Street Object";	
	}
}
sub print_street{
	# Print properties
	print $streetObj->{PrimaryRangeLow}, "-",$streetObj->{PrimaryRangeHigh}, " ";
	print $streetObj->{PrimaryRangeOddEven}, " ", $streetObj->{StreetName}, " ";
	print $streetObj->{suffix}, " ",$streetObj->{PostDirection}, " ";
	print $streetObj->{SuiteName}, " ", $streetObj->{SuiteRangeLow}, "-";
	print $streetObj->{SuiteRangeHigh}, " ", $streetObj->{Zip}, " ";
	print $streetObj->{Plus4Low}, "-", $streetObj->{Plus4High}, "\n";
}

sub init_zipObj{
	# set License
	$zipObj->SetLicenseString($dLICENSE);

	# Set path to data files in the call to the Initialize method
	my $InitResult = $zipObj->Initialize($dFILELOC,$dFILELOC,"");

	if ($InitResult != 0)   # Initialization failed
	{
		printf $zipObj->GetInitializeErrorString(), "\n";
		die "Cannot Initialize Zip Object";	
	}
}

sub print_zip_prop{
	# Print properties
	print $zipObj->{Zip};
	print " ", $zipObj->{ZipType};
	print " ", $zipObj->{CountyName};
	print " ", $zipObj->{AreaCode};
	print " ", $zipObj->{Longitude};
	print " ", $zipObj->{Latitude};
	print " ", $zipObj->{TimeZone};
	print " ", $zipObj->{TimeZoneCode};
	print " ", $zipObj->{msa},;
	print " ", $zipObj->{pmsa}, "\n";
}
sub print_zip_head{
	print "========================================================================\n";
	print "       Build Number: ", $zipObj->GetBuildNumber(), "\n";
	print "  Initialize Status: ", $zipObj->GetInitializeErrorString(), "\n";
	print "      Database Date: ", $zipObj->GetDatabaseDate(), "\n";
	print "========================================================================\n";
}

sub clear_screen{
	my $i;
 	for ($i=0; $i < 25; ++$i){
 	print "\n";
 	}
 }
 		
sub show_menu_screen{
	clear_screen();
	print "========================================================================\n";
	print "Melissa Data Address Object PERL Sample\n";
	print "========================================================================\n";
	print " (1) Verify Address Example\n";
	print " (2) Parse (and Reparse) Address Line Example\n";
	print " (3) Parse Last Line Example\n";
	print " (4) Find Streets in Zip Example\n";
	print " (5) Find City in State Example\n";
	print " (6) Find Zip in City Example\n";
	print " (7) Find Zip Example\n";
	print "========================================================================\n";

}

sub get_menu_input{
	my $menuOption;
	$menuOption=<>;

	if($menuOption==1){
		# call and print addrObject
		verify_address();
		print_addrObj();
	}
	elsif($menuOption==2){
		print "========================================================================\n";
		print "    Build Number: ", $parseObj->GetBuildNumber(), "\n";
		print "  Parsed Address: ", $address, "\n";
		print "========================================================================\n";
		# call and print parseObject
		$parseObj->Parse($address);
		print_parse();
		while ($parseObj->ParseNext()){
			print_parse();
		}
		print "========================================================================\n";
	}
	elsif($menuOption==3){
		# call and print parseObject
		$parseObj->LastLineParse($lastline);
		print_lastline();
	}
	elsif($menuOption==4){
		print "========================================================================\n";
		print "        Build Number: ", $streetObj->GetBuildNumber(), "\n";
		print "   Initialize Status: ", $streetObj->GetInitializeErrorString(), "\n";
		print "       Database Date: ", $streetObj->GetDatabaseDate(), "\n";
		print "========================================================================\n";
		print "Finding street '",$address,"' in zip '",$zip,"'\n";
		print "========================================================================\n";
		#parsing the address to get street.
		$parseObj->Parse($address);
		#calling and checking FindStreet()
		if($streetObj->FindStreet($parseObj->StreetName,$zip,"0")){
			#Successful, so print and then try to find next
			print_street();
			#Loop finding next until false, and no more streets are found
			while($streetObj->FindStreetNext())
			{
				#print results while looping
				print_street();
			}
		}
		else{
			print "Street not Found.\n";
		}

	}
	elsif($menuOption==5){
		print_zip_head();
		print "Finding city '",$city2,"' in state '",$state,"'\n";
		print "========================================================================\n";
		# call and print zipObject
		if($zipObj->FindCityInState($city2,$state)){
			#Successful, so print and then try to find next
			print $zipObj->City,", ",$zipObj->State,"\n";
			#Loop finding next until false, and no more cities are found
			while($zipObj->FindCityInStateNext()){
				#print results while looping
				print $zipObj->City,", ",$zipObj->State,"\n";
			}	
		}
		else{
			print "City not Found.\n";
		}
	}
	elsif($menuOption==6){
		print_zip_head();
		print "Finding zip in ",$city,", ",$state,"\n";
		print "========================================================================\n";
		# call and print zipObject
		if($zipObj->FindZipInCity($city,$state)){
			#Successful, so print and then try to find next
			print_zip_prop();
			#Loop finding next until false, and no more zips are found
			while($zipObj->FindZipInCityNext()){
				#print results while looping
				print_zip_prop();
			}
		}
		else{
			print "Zip not Found.\n";
		}
	}
	elsif($menuOption==7){
		print_zip_head();
		print "Finding zip '",$zip,"'\n";
		print "========================================================================\n";
		# call and print zipObject
		if($zipObj->FindZip($zip)){
			#Successful, so print and then try to find next
			print_zip_prop();
			#Loop finding next until false, and no more zips are found
			while($zipObj->FindZipNext()){
				#print results while looping
				print_zip_prop();
			}
		}
		else{
			print "Zip not Found.\n";
		}
	}
	else{
		print "Invalid Choice.\n";
	}
}


#Main

init_addrObj();
$parseObj->Initialize($dFILELOC);
init_streetObj();
init_zipObj();

show_menu_screen();
get_menu_input();









